/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: NewAndDelete.h,v 1.3 1999/09/23 23:50:54 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_NewAndDelete_h	// [
#define Included_NewAndDelete_h

#include "pgpClassesConfig.h"

// Implements C++ ANSI new and delete operators, with a few little twists.
// We throw a CComboError instead of a std::bad_alloc because we don't work
// with the STL yet. Otherwise, we try to be ANSI-like.
//
// Note the additional overloads of new for allocating secure memory. Cool!

// Types

namespace std
{
	typedef unsigned int size_t;

	struct nothrow_t {};
	const nothrow_t nothrow;
}

_PGP_BEGIN

namespace NewAndDelete
{
	enum MemoryType
	{
		kSecureMemType		= 1, 
		kNonSecureMemType	= 2, 

	#if defined(PGP_DRIVER98) || defined(PGP_DRIVERNT)
		kDefaultMemType	= kSecureMemType, 
	#else	// !(PGP_DRIVER98 || PGP_DRIVERNT)
		kDefaultMemType	= kNonSecureMemType
	#endif	// PGP_DRIVER98 || PGP_DRIVERNT
	};

	void *	NewHelper(std::size_t size, MemoryType type, 
		PGPBoolean throws = PGP_EXCEPTIONS);
	void	DeleteHelper(void *p);
}

_PGP_END


// Operator new functions

inline 
void * 
_cdecl 
operator new(std::size_t size)
{
	return PGP::NewAndDelete::NewHelper(size, 
		PGP::NewAndDelete::kDefaultMemType);
}

inline 
void * 
_cdecl 
operator new[](std::size_t size)
{
	return PGP::NewAndDelete::NewHelper(size, 
		PGP::NewAndDelete::kDefaultMemType);
}

inline 
void * 
_cdecl 
operator new(std::size_t size, PGP::NewAndDelete::MemoryType memType)
{
	return PGP::NewAndDelete::NewHelper(size, memType);
}

inline 
void * 
_cdecl 
operator new[](std::size_t size, PGP::NewAndDelete::MemoryType memType)
{
	return PGP::NewAndDelete::NewHelper(size, memType);
}

inline 
void * 
_cdecl 
operator new(std::size_t size, const std::nothrow_t&)
{
	return PGP::NewAndDelete::NewHelper(size, 
		PGP::NewAndDelete::kDefaultMemType, FALSE);
}

inline 
void * 
_cdecl 
operator new[](std::size_t size, const std::nothrow_t&)
{
	return PGP::NewAndDelete::NewHelper(size, 
		PGP::NewAndDelete::kDefaultMemType, FALSE);
}

inline 
void * 
_cdecl 
operator new(
	std::size_t						size, 
	const std::nothrow_t&			dummy, 
	PGP::NewAndDelete::MemoryType	memType)
{
	return PGP::NewAndDelete::NewHelper(size, memType, FALSE);
}

inline 
void * 
_cdecl 
operator new[](
	std::size_t						size, 
	const std::nothrow_t&			dummy, 
	PGP::NewAndDelete::MemoryType	memType)
{
	return PGP::NewAndDelete::NewHelper(size, memType, FALSE);
}

// Placement new.

inline 
void * 
_cdecl 
operator new(std::size_t size, void *pMem)
{
	return pMem;
}

inline 
void * 
_cdecl 
operator new[](std::size_t size, void *pMem)
{
	return pMem;
}


// Operator delete functions

inline 
void 
_cdecl 
operator delete(void *p)
{ 
	PGP::NewAndDelete::DeleteHelper(p);
}

inline 
void 
_cdecl 
operator delete[](void *p)
{ 
	PGP::NewAndDelete::DeleteHelper(p);
}

inline 
void 
_cdecl 
operator delete(void *p, PGP::NewAndDelete::MemoryType memType)
{ 
	PGP::NewAndDelete::DeleteHelper(p);
}

inline 
void 
_cdecl 
operator delete[](void *p, PGP::NewAndDelete::MemoryType memType)
{ 
	PGP::NewAndDelete::DeleteHelper(p);
}

inline 
void 
_cdecl 
operator delete(void *p, const std::nothrow_t&)
{ 
	PGP::NewAndDelete::DeleteHelper(p);
}

inline 
void 
_cdecl 
operator delete[](void *p, const std::nothrow_t&)
{ 
	PGP::NewAndDelete::DeleteHelper(p);
}

inline 
void 
_cdecl 
operator delete(
	void							*p, 
	const std::nothrow_t&			dummy, 
	PGP::NewAndDelete::MemoryType	memType)
{ 
	PGP::NewAndDelete::DeleteHelper(p);
}

inline 
void 
_cdecl 
operator delete[](
	void							*p, 
	const std::nothrow_t&			dummy, 
	PGP::NewAndDelete::MemoryType	memType)
{ 
	PGP::NewAndDelete::DeleteHelper(p);
}


// Placement delete.

inline 
void 
_cdecl 
operator delete(void *pMem1, void *pMem2)
{
	return;
}

inline 
void 
_cdecl 
operator delete[](void *pMem1, void *pMem2)
{
	return;
}


// Class auto_ptr (from VC STL)

template<class _Ty>
	class auto_ptr {
public:
	typedef _Ty element_type;
	explicit auto_ptr(_Ty *_P = 0)
		: _Owns(_P != 0), _Ptr(_P) {}
	auto_ptr(const auto_ptr<_Ty>& _Y)
		: _Owns(_Y._Owns), _Ptr(_Y.release()) {}
	auto_ptr<_Ty>& operator=(const auto_ptr<_Ty>& _Y)
		{if (this != &_Y)
			{if (_Ptr != _Y.get())
				{if (_Owns)
					delete _Ptr;
				_Owns = _Y._Owns; }
			else if (_Y._Owns)
				_Owns = true;
			_Ptr = _Y.release(); }
		return (*this); }
	~auto_ptr()
		{if (_Owns)
			delete _Ptr; }
	_Ty& operator*() const
		{return (*get()); }
	_Ty *operator->() const
		{return (get()); }
	_Ty *get() const
		{return (_Ptr); }
	_Ty *release() const
		{((auto_ptr<_Ty> *)this)->_Owns = false;
		return (_Ptr); }
private:
	bool _Owns;
	_Ty *_Ptr;
};

#endif	// ] Included_NewAndDelete_h
